/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.IVWConfigTreeNode;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWSessionInfo;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class VWConfigQueueNode
extends VWConfigBaseNode
implements IVWConfigTreeNode {
    private static final ImageIcon compQueueIcon32 = VWImageLoader.createImageIcon("q_comp_32.gif");
    private static final ImageIcon userQueueIcon32 = VWImageLoader.createImageIcon("q_user_32.gif");
    private static final ImageIcon workQueueIcon32 = VWImageLoader.createImageIcon("q_work_32.gif");
    private static final ImageIcon compQueueIcon16 = VWImageLoader.createImageIcon("q_comp_16.gif");
    private static final ImageIcon userQueueIcon16 = VWImageLoader.createImageIcon("q_user_16.gif");
    private static final ImageIcon workQueueIcon16 = VWImageLoader.createImageIcon("q_work_16.gif");
    private VWQueueDefinition m_queueDefinition = null;
    private VWSystemConfiguration m_sysConfig = null;

    public VWConfigQueueNode(VWSessionInfo sessionInfo, VWQueueDefinition queueDef, String service, int regionID, int serverID, VWSystemConfiguration sysConfig) {
        super(queueDef.getName(), null);
        try {
            this.m_sessionInfo = sessionInfo;
            this.m_queueDefinition = queueDef;
            this.m_serviceName = service;
            this.m_regionID = regionID;
            this.m_serverID = serverID;
            this.m_sysConfig = sysConfig;
            this.m_description = this.m_queueDefinition.getDescription();
            switch (queueDef.getQueueType()) {
                case 1: {
                    if (queueDef.getIsConnectorQueue()) {
                        this.setType(5);
                        this.setActionCommandString(VWConfigActionCommand.ACMD_COMP_QUEUE);
                        this.setIcon32(compQueueIcon32);
                        this.setIcon16(compQueueIcon16);
                        break;
                    }
                    this.setType(1);
                    this.setActionCommandString(VWConfigActionCommand.ACMD_WORK_QUEUE);
                    this.setIcon32(workQueueIcon32);
                    this.setIcon16(workQueueIcon16);
                    break;
                }
                case 2: {
                    this.setType(2);
                    this.setActionCommandString(VWConfigActionCommand.ACMD_USER_QUEUE);
                    this.setIcon32(userQueueIcon32);
                    this.setIcon16(userQueueIcon16);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int countWorkItemsAffected() {
        try {
            if (this.m_eventStatus != 9) {
                VWQueue vwQueue = this.m_sessionInfo.getSession().getQueue(this.m_name);
                this.m_workItemsAffected = vwQueue.fetchCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_workItemsAffected;
    }

    public Object clone() {
        VWConfigQueueNode qNode = (VWConfigQueueNode)super.clone();
        qNode.m_queueDefinition = (VWQueueDefinition)this.m_queueDefinition.clone();
        qNode.m_sysConfig = this.m_sysConfig;
        return qNode;
    }

    public void releaseResources() {
        this.m_queueDefinition = null;
        this.m_sysConfig = null;
        super.releaseResources();
    }

    public void selectExportComponents() {
        try {
            VWClassFactory.setIsSelectedForExport(this.m_queueDefinition, this.m_exportOpt == 2, 234L);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected VWQueueDefinition getDefinition() {
        if (this.m_queueDefinition != null) {
            return (VWQueueDefinition)this.m_queueDefinition.clone();
        }
        return null;
    }

    protected void setDefinition(VWQueueDefinition newQueueDef) {
        try {
            if (this.m_sysConfig != null && newQueueDef != null) {
                this.m_sysConfig.updateQueueDefinition(newQueueDef);
                this.m_queueDefinition = newQueueDef;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWSystemConfiguration getSystemConfiguration() {
        return this.m_sysConfig;
    }

    protected Hashtable getWorkBasketMap(VWQueueDefinition clonedQueueDef) throws Exception {
        if (this.m_queueDefinition != null && clonedQueueDef != null) {
            VWWorkBasketDefinition[] origWorkBasketDefs = this.m_queueDefinition.getWorkBasketDefinitions();
            if (origWorkBasketDefs == null || origWorkBasketDefs.length == 0) {
                return null;
            }
            Hashtable<VWWorkBasketDefinition, VWWorkBasketDefinition> hashTable = new Hashtable<VWWorkBasketDefinition, VWWorkBasketDefinition>(origWorkBasketDefs.length);
            for (int nIndex = 0; nIndex < origWorkBasketDefs.length; ++nIndex) {
                try {
                    VWWorkBasketDefinition clonedWorkBasketDef = clonedQueueDef.getWorkBasketDefinition(origWorkBasketDefs[nIndex].getName());
                    if (clonedWorkBasketDef == null) continue;
                    hashTable.put(origWorkBasketDefs[nIndex], clonedWorkBasketDef);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return hashTable;
        }
        return null;
    }
}

